/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.FileTypeBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.ImageInputStreamWrapper;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.SignatureBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.XMLBox;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.util.ISRandomAccessIO;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class J2KMetadata
extends IIOMetadata
implements Cloneable {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
    private J2KMetadataFormat format;
    private ArrayList boxes = new ArrayList();

    public J2KMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat", null, null);
        this.format = (J2KMetadataFormat)this.getMetadataFormat(nativeMetadataFormatName);
    }

    public J2KMetadata(ImageInputStream iis, J2KImageReader reader) throws IOException {
        this();
        ImageInputStreamWrapper is = new ImageInputStreamWrapper(iis);
        int dataLen = (int)iis.length();
        ISRandomAccessIO in = null;
        in = dataLen != -1 ? new ISRandomAccessIO(is, dataLen, 1, dataLen) : new ISRandomAccessIO(is);
        iis.mark();
        FileFormatReader ff = new FileFormatReader(in, this);
        ff.readFileFormat();
        iis.reset();
    }

    public J2KMetadata(ImageWriteParam param, ImageWriter writer) {
        this(null, param, writer);
    }

    public J2KMetadata(ImageTypeSpecifier imageType, ImageWriteParam param, ImageWriter writer) {
        this(imageType != null ? imageType.getColorModel() : null, imageType != null ? imageType.getSampleModel() : null, 0, 0, param, writer);
    }

    public J2KMetadata(ColorModel colorModel, SampleModel sampleModel, int width, int height, ImageWriteParam param, ImageWriter writer) {
        this();
        this.addNode(new SignatureBox());
        this.addNode(new FileTypeBox(1785737760, 0, new int[]{1785737760}));
        ImageTypeSpecifier destType = null;
        if (param != null) {
            destType = param.getDestinationType();
            if (colorModel == null && sampleModel == null) {
                colorModel = destType == null ? null : destType.getColorModel();
                SampleModel sampleModel2 = sampleModel = destType == null ? null : destType.getSampleModel();
            }
        }
        if (colorModel != null) {
            ColorSpace cs = colorModel.getColorSpace();
            boolean iccColor = cs instanceof ICC_ColorSpace;
            int type = cs.getType();
            if (type == 5) {
                this.addNode(new ColorSpecificationBox(1, 0, 0, 16, null));
            } else if (type == 6) {
                this.addNode(new ColorSpecificationBox(1, 0, 0, 17, null));
            } else if (cs instanceof ICC_ColorSpace) {
                this.addNode(new ColorSpecificationBox(2, 0, 0, 0, ((ICC_ColorSpace)cs).getProfile()));
            }
            if (colorModel.hasAlpha()) {
                this.addNode(new ChannelDefinitionBox(colorModel));
            }
            if (colorModel instanceof IndexColorModel) {
                this.addNode(new PaletteBox((IndexColorModel)colorModel));
                int numComp = colorModel.getComponentSize().length;
                short[] channels = new short[numComp];
                byte[] types = new byte[numComp];
                byte[] maps = new byte[numComp];
                int i = 0;
                while (i < numComp) {
                    channels[i] = 0;
                    types[i] = 1;
                    maps[i] = (byte)i;
                    ++i;
                }
                this.addNode(new ComponentMappingBox(channels, types, maps));
            }
        }
        if (sampleModel != null) {
            if (width <= 0) {
                width = sampleModel.getWidth();
            }
            if (height <= 0) {
                height = sampleModel.getHeight();
            }
            this.addNode(new HeaderBox(height, width, sampleModel.getNumBands(), sampleModel.getSampleSize(0) - 1 | (this.isOriginalSigned(sampleModel) ? 128 : 0), 7, colorModel == null ? 1 : 0, this.getElement("JPEG2000IntellectualPropertyRightsBox") == null ? 0 : 1));
        }
    }

    public Object clone() {
        J2KMetadata theClone = null;
        try {
            theClone = (J2KMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        if (this.boxes != null) {
            int numBoxes = this.boxes.size();
            int i = 0;
            while (i < numBoxes) {
                theClone.addNode((Box)this.boxes.get(i));
                ++i;
            }
        }
        return theClone;
    }

    public Node getAsTree(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("J2KMetadata1") + " " + formatName);
    }

    IIOMetadataNode getNativeTree() {
        IIOMetadataNode root = new IIOMetadataNode(nativeMetadataFormatName);
        Box signatureBox = null;
        Box fileTypeBox = null;
        Box headerBox = null;
        int signatureIndex = -1;
        int fileTypeIndex = -1;
        int headerIndex = -1;
        int numBoxes = this.boxes.size();
        int found = 0;
        int i = 0;
        while (i < numBoxes && found < 3) {
            Box box = (Box)this.boxes.get(i);
            if (Box.getName(box.getType()).equals("JPEG2000SignatureBox")) {
                signatureBox = box;
                signatureIndex = i;
                ++found;
            } else if (Box.getName(box.getType()).equals("JPEG2000FileTypeBox")) {
                fileTypeBox = box;
                fileTypeIndex = i;
                ++found;
            } else if (Box.getName(box.getType()).equals("JPEG2000HeaderBox")) {
                headerBox = box;
                headerIndex = i;
                ++found;
            }
            ++i;
        }
        if (signatureBox != null) {
            this.insertNodeIntoTree(root, signatureBox.getNativeNode());
        }
        if (fileTypeBox != null) {
            this.insertNodeIntoTree(root, fileTypeBox.getNativeNode());
        }
        if (headerBox != null) {
            this.insertNodeIntoTree(root, headerBox.getNativeNode());
        }
        int i2 = 0;
        while (i2 < numBoxes) {
            if (i2 != signatureIndex && i2 != fileTypeIndex && i2 != headerIndex) {
                Box box = (Box)this.boxes.get(i2);
                IIOMetadataNode node = box.getNativeNode();
                this.insertNodeIntoTree(root, node);
            }
            ++i2;
        }
        return root;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        HeaderBox header = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        PaletteBox palette = (PaletteBox)this.getElement("JPEG2000PaletteBox");
        ColorSpecificationBox color = (ColorSpecificationBox)this.getElement("JPEG2000ColorSpecificationBox");
        IIOMetadataNode node = new IIOMetadataNode("Chroma");
        IIOMetadataNode subNode = null;
        if (header != null) {
            if (header.getUnknownColorspace() == 0 && color != null && color.getMethod() == 1) {
                subNode = new IIOMetadataNode("ColorSpaceType");
                int ecs = color.getEnumeratedColorSpace();
                if (ecs == 16) {
                    subNode.setAttribute("name", "RGB");
                }
                if (ecs == 17) {
                    subNode.setAttribute("name", "GRAY");
                }
                node.appendChild(subNode);
            }
            subNode = new IIOMetadataNode("NumChannels");
            subNode.setAttribute("value", "" + header.getNumComponents());
            node.appendChild(subNode);
            if (palette != null) {
                subNode.setAttribute("value", "" + palette.getNumComp());
                subNode = new IIOMetadataNode("Palette");
                byte[][] lut = palette.getLUT();
                int size = lut[0].length;
                int numComp = lut.length;
                int i = 0;
                while (i < size) {
                    IIOMetadataNode subNode1 = new IIOMetadataNode("PaletteEntry");
                    subNode1.setAttribute("index", "" + i);
                    subNode1.setAttribute("red", "" + (lut[0][i] & 0xFF));
                    subNode1.setAttribute("green", "" + (lut[1][i] & 0xFF));
                    subNode1.setAttribute("blue", "" + (lut[2][i] & 0xFF));
                    if (numComp == 4) {
                        subNode1.setAttribute("alpha", "" + (lut[3][i] & 0xFF));
                    }
                    subNode.appendChild(subNode1);
                    ++i;
                }
                node.appendChild(subNode);
            }
        }
        return node;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode node = new IIOMetadataNode("Compression");
        IIOMetadataNode subNode = new IIOMetadataNode("CompressionTypeName");
        subNode.setAttribute("value", "JPEG2000");
        node.appendChild(subNode);
        return node;
    }

    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode node = new IIOMetadataNode("Data");
        PaletteBox palette = (PaletteBox)this.getElement("JPEG2000PaletteBox");
        boolean sampleFormat = false;
        if (palette != null) {
            IIOMetadataNode subNode = new IIOMetadataNode("SampleFormat");
            subNode.setAttribute("value", "Index");
            node.appendChild(subNode);
            sampleFormat = true;
        }
        BitsPerComponentBox bitDepth = (BitsPerComponentBox)this.getElement("JPEG2000BitsPerComponentBox");
        String value = "";
        boolean signed = false;
        if (bitDepth != null) {
            byte[] bits = bitDepth.getBitDepth();
            if ((bits[0] & 0x80) == 128) {
                signed = true;
            }
            int numComp = bits.length;
            int i = 0;
            while (i < numComp) {
                value = value + ((bits[i] & 0x7F) + 1);
                if (i != numComp - 1) {
                    value = value + " ";
                }
                ++i;
            }
        } else {
            HeaderBox header = (HeaderBox)this.getElement("JPEG2000HeaderBox");
            int bits = header.getBitDepth();
            if ((bits & 0x80) == 128) {
                signed = true;
            }
            bits = (bits & 0x7F) + 1;
            int numComp = header.getNumComponents();
            int i = 0;
            while (i < numComp) {
                value = value + bits;
                if (i != numComp - 1) {
                    value = value + " ";
                }
                ++i;
            }
        }
        IIOMetadataNode subNode = new IIOMetadataNode("BitsPerSample");
        subNode.setAttribute("value", value);
        node.appendChild(subNode);
        subNode = new IIOMetadataNode("PlanarConfiguration");
        subNode.setAttribute("value", "TileInterleaved");
        node.appendChild(subNode);
        if (!sampleFormat) {
            subNode = new IIOMetadataNode("SampleFormat");
            subNode.setAttribute("value", signed ? "SignedIntegral" : "UnsignedIntegral");
            node.appendChild(subNode);
        }
        return node;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        ResolutionBox box = (ResolutionBox)this.getElement("JPEG2000CaptureResolutionBox");
        if (box != null) {
            IIOMetadataNode node = new IIOMetadataNode("Dimension");
            float hRes = box.getHorizontalResolution();
            float vRes = box.getVerticalResolution();
            float ratio = vRes / hRes;
            IIOMetadataNode subNode = new IIOMetadataNode("PixelAspectRatio");
            subNode.setAttribute("value", "" + ratio);
            node.appendChild(subNode);
            subNode = new IIOMetadataNode("HorizontalPixelSize");
            subNode.setAttribute("value", "" + 1000.0f / hRes);
            node.appendChild(subNode);
            subNode = new IIOMetadataNode("VerticalPixelSize");
            subNode.setAttribute("value", "" + 1000.0f / vRes);
            node.appendChild(subNode);
            return node;
        }
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        ChannelDefinitionBox channel = (ChannelDefinitionBox)this.getElement("JPEG2000ChannelDefinitionBox");
        if (channel != null) {
            IIOMetadataNode node = new IIOMetadataNode("Transparency");
            boolean hasAlpha = false;
            boolean isPremultiplied = false;
            short[] type = channel.getTypes();
            int i = 0;
            while (i < type.length) {
                if (type[i] == 1) {
                    hasAlpha = true;
                }
                if (type[i] == 2) {
                    isPremultiplied = true;
                }
                ++i;
            }
            String value = "none";
            if (isPremultiplied) {
                value = "premultiplied";
            } else if (hasAlpha) {
                value = "nonpremultiplied";
            }
            IIOMetadataNode subNode = new IIOMetadataNode("Alpha");
            subNode.setAttribute("value", value);
            node.appendChild(subNode);
            return node;
        }
        IIOMetadataNode node = new IIOMetadataNode("Transparency");
        IIOMetadataNode subNode = new IIOMetadataNode("Alpha");
        subNode.setAttribute("value", "none");
        node.appendChild(subNode);
        return null;
    }

    protected IIOMetadataNode getStandardTextNode() {
        if (this.boxes == null) {
            return null;
        }
        IIOMetadataNode text = null;
        Iterator iterator = this.boxes.iterator();
        while (iterator.hasNext()) {
            Box box = (Box)iterator.next();
            if (!(box instanceof XMLBox)) continue;
            if (text == null) {
                text = new IIOMetadataNode("Text");
            }
            IIOMetadataNode subNode = new IIOMetadataNode("TextEntry");
            String content = new String(box.getContent());
            subNode.setAttribute("value", content);
            text.appendChild(subNode);
        }
        return text;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (root == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata2"));
        }
        if (formatName.equals(nativeMetadataFormatName) && root.getNodeName().equals(nativeMetadataFormatName)) {
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata1") + " " + formatName);
        }
    }

    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (root == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata2"));
        }
        if (formatName.equals(nativeMetadataFormatName) && root.getNodeName().equals(nativeMetadataFormatName)) {
            this.boxes = new ArrayList();
            this.mergeNativeTree(root);
        } else if (formatName.equals("javax_imageio_1.0")) {
            this.boxes = new ArrayList();
            this.mergeStandardTree(root);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata1") + " " + formatName);
        }
    }

    public void reset() {
        this.boxes.clear();
    }

    public void addNode(Box node) {
        if (this.boxes == null) {
            this.boxes = new ArrayList();
        }
        this.replace(Box.getName(node.getType()), node);
    }

    public Box getElement(String name) {
        int i = this.boxes.size() - 1;
        while (i >= 0) {
            Box box = (Box)this.boxes.get(i);
            if (name.equals(Box.getName(box.getType()))) {
                return box;
            }
            --i;
        }
        return null;
    }

    private void mergeNativeTree(Node root) throws IIOInvalidTreeException {
        NodeList list = root.getChildNodes();
        int i = list.getLength() - 1;
        while (i >= 0) {
            Node node = list.item(i);
            String name = node.getNodeName();
            if (this.format.getParent(name) != null) {
                if (this.format.isLeaf(name)) {
                    String s = (String)Box.getAttribute(node, "Type");
                    Box box = Box.createBox(Box.getTypeInt(s), node);
                    if (this.format.singleInstance(name) && this.getElement(name) != null) {
                        this.replace(name, box);
                    } else {
                        this.boxes.add(box);
                    }
                } else {
                    this.mergeNativeTree(node);
                }
            }
            --i;
        }
    }

    private void mergeStandardTree(Node root) throws IIOInvalidTreeException {
        NodeList children = root.getChildNodes();
        int numComps = 0;
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String name = node.getNodeName();
            if (name.equals("Chroma")) {
                NodeList children1 = node.getChildNodes();
                int j = 0;
                while (j < children1.getLength()) {
                    Node child = children1.item(j);
                    String name1 = child.getNodeName();
                    if (name1.equals("NumChannels")) {
                        String s = (String)Box.getAttribute(child, "value");
                        numComps = new Integer(s);
                    }
                    if (name1.equals("ColorSpaceType")) {
                        this.createColorSpecificationBoxFromStandardNode(child);
                    }
                    if (name1.equals("Palette")) {
                        this.createPaletteBoxFromStandardNode(child);
                    }
                    ++j;
                }
            } else if (!name.equals("Compression")) {
                if (name.equals("Data")) {
                    this.createBitsPerComponentBoxFromStandardNode(node);
                    this.createHeaderBoxFromStandardNode(node, numComps);
                } else if (name.equals("Dimension")) {
                    this.createResolutionBoxFromStandardNode(node);
                } else if (name.equals("Document")) {
                    this.createXMLBoxFromStandardNode(node);
                } else if (name.equals("Text")) {
                    this.createXMLBoxFromStandardNode(node);
                } else if (name.equals("Transparency")) {
                    this.createChannelDefinitionFromStandardNode(node);
                } else {
                    throw new IIOInvalidTreeException(I18N.getString("J2KMetadata3") + " " + name, node);
                }
            }
            ++i;
        }
    }

    private void createColorSpecificationBoxFromStandardNode(Node node) {
        int ecs;
        if (node.getNodeName() != "ColorSpaceType") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata4"));
        }
        String name = (String)Box.getAttribute(node, "name");
        int n = name.equals("RGB") ? 16 : (ecs = name.equals("Gray") ? 17 : 0);
        if (ecs == 16 || ecs == 17) {
            this.replace("JPEG2000ColorSpecificationBox", new ColorSpecificationBox(1, 0, 0, ecs, null));
        }
    }

    private void createPaletteBoxFromStandardNode(Node node) {
        if (node.getNodeName() != "Palette") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata5"));
        }
        NodeList children = node.getChildNodes();
        int maxIndex = -1;
        boolean hasAlpha = false;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("PaletteEntry")) {
                String s = (String)Box.getAttribute(child, "index");
                int index = new Integer(s);
                if (index > maxIndex) {
                    maxIndex = index;
                }
                if (Box.getAttribute(child, "alpha") != null) {
                    hasAlpha = true;
                }
            }
            ++i;
        }
        int numBits = 32;
        int mask = Integer.MIN_VALUE;
        while (mask != 0 && (maxIndex & mask) == 0) {
            --numBits;
            mask >>>= 1;
        }
        int size = 1 << numBits;
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        byte[] alpha = hasAlpha ? new byte[size] : null;
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node child = children.item(i2);
            String name = child.getNodeName();
            if (name.equals("PaletteEntry")) {
                String s = (String)Box.getAttribute(child, "index");
                int index = new Integer(s);
                s = (String)Box.getAttribute(child, "red");
                red[index] = (byte)new Integer(s).intValue();
                s = (String)Box.getAttribute(child, "green");
                green[index] = (byte)new Integer(s).intValue();
                s = (String)Box.getAttribute(child, "blue");
                blue[index] = (byte)new Integer(s).intValue();
                int t = -1;
                s = (String)Box.getAttribute(child, "alpha");
                if (s != null) {
                    t = (byte)new Integer(s).intValue();
                }
                if (alpha != null) {
                    alpha[index] = t;
                }
            }
            ++i2;
        }
        IndexColorModel icm = alpha == null ? new IndexColorModel(numBits, size, red, green, blue) : new IndexColorModel(numBits, size, red, green, blue, alpha);
        this.replace("JPEG2000PaletteBox", new PaletteBox(icm));
    }

    private void createBitsPerComponentBoxFromStandardNode(Node node) {
        if (node.getNodeName() != "Data") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata6"));
        }
        NodeList children = node.getChildNodes();
        byte[] bits = null;
        boolean isSigned = false;
        int i = 0;
        while (i < children.getLength()) {
            String s;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("BitsPerSample")) {
                s = (String)Box.getAttribute(child, "value");
                bits = (byte[])Box.parseByteArray(s).clone();
            } else if (name.equals("SampleFormat")) {
                s = (String)Box.getAttribute(child, "value");
                isSigned = s.equals("SignedIntegral");
            }
            ++i;
        }
        if (bits != null) {
            int i2 = 0;
            while (i2 < bits.length) {
                bits[i2] = (byte)((bits[i2] & 0xFF) - 1);
                if (isSigned) {
                    int n = i2;
                    bits[n] = (byte)(bits[n] | 0x80);
                }
                ++i2;
            }
            this.replace("JPEG2000BitsPerComponent", new BitsPerComponentBox(bits));
        }
    }

    private void createResolutionBoxFromStandardNode(Node node) {
        if (node.getNodeName() != "Dimension") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata7"));
        }
        NodeList children = node.getChildNodes();
        float hRes = 0.0f;
        float vRes = 0.0f;
        boolean gotH = false;
        boolean gotV = false;
        int i = 0;
        while (i < children.getLength()) {
            String s;
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("HorizontalPixelSize")) {
                s = (String)Box.getAttribute(child, "value");
                hRes = new Float(s).floatValue();
                hRes = 1000.0f / hRes;
                gotH = true;
            }
            if (name.equals("VerticalPixelSize")) {
                s = (String)Box.getAttribute(child, "value");
                vRes = new Float(s).floatValue();
                vRes = 1000.0f / vRes;
                gotV = true;
            }
            ++i;
        }
        if (gotH && !gotV) {
            vRes = hRes;
        } else if (gotV && !gotH) {
            hRes = vRes;
        }
        if (gotH || gotV) {
            this.replace("JPEG2000CaptureResolutionBox", new ResolutionBox(1919251299, hRes, vRes));
        }
    }

    private void createXMLBoxFromStandardNode(Node node) {
        NodeList children = node.getChildNodes();
        String value = "<" + node.getNodeName() + ">";
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            value = value + "<" + name + " ";
            NamedNodeMap map = child.getAttributes();
            int j = 0;
            while (j < map.getLength()) {
                Node att = map.item(j);
                value = value + att.getNodeName() + "=\"" + att.getNodeValue() + "\" ";
                ++j;
            }
            value = value + " />";
            ++i;
        }
        value = value + "</" + node.getNodeName() + ">";
        this.boxes.add(new XMLBox(value.getBytes()));
    }

    private void createHeaderBoxFromStandardNode(Node node, int numComps) {
        HeaderBox header = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        byte unknownColor = (byte)(this.getElement("JPEG2000ColorSpecificationBox") == null ? 1 : 0);
        if (header != null) {
            if (numComps == 0) {
                // empty if block
            }
            numComps = header.getNumComponents();
            header = new HeaderBox(header.getHeight(), header.getWidth(), numComps, header.getBitDepth(), header.getCompressionType(), unknownColor, header.getIntellectualProperty());
        } else {
            header = new HeaderBox(0, 0, numComps, 0, 0, unknownColor, 0);
        }
        this.replace("JPEG2000HeaderBox", header);
    }

    private void createChannelDefinitionFromStandardNode(Node node) {
        if (node.getNodeName() != "Transparency") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata8"));
        }
        HeaderBox header = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        int numComps = 3;
        if (header != null) {
            numComps = header.getNumComponents();
        }
        NodeList children = node.getChildNodes();
        boolean hasAlpha = false;
        boolean isPremultiplied = false;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("Alpha")) {
                String value = (String)Box.getAttribute(child, "value");
                if (value.equals("premultiplied")) {
                    isPremultiplied = true;
                }
                if (value.equals("nonpremultiplied")) {
                    hasAlpha = true;
                }
            }
            ++i;
        }
        if (!hasAlpha) {
            return;
        }
        short num = (short)(numComps * (isPremultiplied ? 3 : 2));
        short[] channels = new short[num];
        short[] types = new short[num];
        short[] associations = new short[num];
        ChannelDefinitionBox.fillBasedOnBands(numComps, isPremultiplied, channels, types, associations);
        this.replace("JPEG2000ChannelDefinitionBox", new ChannelDefinitionBox(channels, types, associations));
    }

    private void replace(String name, Box box) {
        int i = this.boxes.size() - 1;
        while (i >= 0) {
            Box box1 = (Box)this.boxes.get(i);
            if (name.equals(Box.getName(box1.getType()))) {
                this.boxes.set(i, box);
                return;
            }
            --i;
        }
        this.boxes.add(box);
    }

    private boolean insertNodeIntoTree(IIOMetadataNode root, IIOMetadataNode node) {
        String name = node.getNodeName();
        String parent = this.format.getParent(name);
        if (parent == null) {
            return false;
        }
        IIOMetadataNode parentNode = this.getNodeFromTree(root, parent, name);
        if (parentNode == null) {
            parentNode = this.createNodeIntoTree(root, parent);
        }
        parentNode.appendChild(node);
        return true;
    }

    private IIOMetadataNode getNodeFromTree(IIOMetadataNode root, String name, String childName) {
        if (name.equals(root.getNodeName())) {
            return root;
        }
        NodeList list = root.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            IIOMetadataNode node = (IIOMetadataNode)list.item(i);
            if (node.getNodeName().equals(name)) {
                if (!name.equals("JPEG2000UUIDInfoBox") || !this.checkUUIDInfoBox(node, childName)) {
                    return node;
                }
            } else if ((node = this.getNodeFromTree(node, name, childName)) != null) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private IIOMetadataNode createNodeIntoTree(IIOMetadataNode root, String name) {
        IIOMetadataNode node = this.getNodeFromTree(root, name, null);
        if (node != null) {
            return node;
        }
        node = new IIOMetadataNode(name);
        String parent = this.format.getParent(name);
        IIOMetadataNode parentNode = this.createNodeIntoTree(root, parent);
        parentNode.appendChild(node);
        return node;
    }

    private boolean isOriginalSigned(SampleModel sampleModel) {
        int type = sampleModel.getDataType();
        return type != 0 && type != 1;
    }

    private boolean checkUUIDInfoBox(Node node, String childName) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            IIOMetadataNode child = (IIOMetadataNode)list.item(i);
            String name = child.getNodeName();
            if (name.equals(childName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        nativeMetadataFormatName = nativeMetadataFormatName;
    }
}

